package cn.datax.workflow.modeler.controller;

import org.flowable.ui.common.model.RemoteUser;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.common.security.SecurityUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/app")
public class RemoteAccountResource {

    @GetMapping(value = "/rest/account", produces = "application/json")
    public UserRepresentation getAccount() {
        RemoteUser remoteUser= new RemoteUser();
        remoteUser.setFirstName("admin");
        remoteUser.setLastName("");
        remoteUser.setFullName("administrator");
        remoteUser.setEmail("admin@qq.com");
        remoteUser.setId("admin");
        // 构建用户代表类
        UserRepresentation userRepresentation = new UserRepresentation(remoteUser);
        // 保证创建流程可用
        SecurityUtils.assumeUser(remoteUser);
        return userRepresentation;
    }
}
