import request from '@/utils/request'

export function listDataSet (data) {
  return request({
    url: '/data/factory/dataSets/list',
    method: 'get',
    params: data
  })
}

export function pageDataSet (data) {
  return request({
    url: '/data/factory/dataSets/page',
    method: 'get',
    params: data
  })
}

export function getDataSet (id) {
  return request({
    url: '/data/factory/dataSets/' + id,
    method: 'get'
  })
}

export function delDataSet (id) {
  return request({
    url: '/data/factory/dataSets/' + id,
    method: 'delete'
  })
}

export function delDataSets (ids) {
  return request({
    url: '/data/factory/dataSets/batch/' + ids,
    method: 'delete'
  })
}

export function addDataSet (data) {
  return request({
    url: '/data/factory/dataSets',
    method: 'post',
    data: data
  })
}

export function updateDataSet (data) {
  return request({
    url: '/data/factory/dataSets/' + data.id,
    method: 'put',
    data: data
  })
}
