package cn.datax.service.data.market.api.call.config;

import cn.datax.service.data.market.api.call.service.ApiCallEngine;
import cn.datax.service.data.market.api.call.service.ApiLogService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
public class ApiHandlerConfig {

    @Bean
    public MappingHandlerMapping mappingHandlerMapping(RequestMappingHandlerMapping requestMappingHandlerMapping, ApiCallEngine apiCallEngine, RedisTemplate redisTemplate, ApiLogService apiLogService) {
        MappingHandlerMapping mappingHandlerMapping = new MappingHandlerMapping();
        mappingHandlerMapping.setHandler(requestHandler(apiCallEngine, redisTemplate, apiLogService));
        mappingHandlerMapping.setRequestMappingHandlerMapping(requestMappingHandlerMapping);
        return mappingHandlerMapping;
    }

    @Bean
    public RequestHandler requestHandler(ApiCallEngine apiCallEngine, RedisTemplate redisTemplate, ApiLogService apiLogService) {
        RequestHandler handler = new RequestHandler();
        handler.setApiCallEngine(apiCallEngine);
        handler.setApiLogService(apiLogService);
        handler.setRequestInterceptor(new RequestInterceptor(redisTemplate));
        return handler;
    }
}
