package cn.datax.service.data.market.api.feign;

import cn.datax.common.core.R;
import cn.datax.service.data.market.api.feign.factory.DataApiServiceFeignFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@FeignClient(contextId = "dataApiServiceFeign", value = "datax-service-data-market", fallbackFactory = DataApiServiceFeignFallbackFactory.class)
public interface DataApiServiceFeign {

    @GetMapping("/dataApis/{id}")
    R getDataApiById(@PathVariable("id") String id);

    @GetMapping("/dataApis/list")
    R getDataApiList();
}
