package cn.datax.service.workflow.service;

import cn.datax.service.workflow.api.dto.ProcessInstanceCreateRequest;
import cn.datax.service.workflow.api.query.FlowInstanceQuery;

import java.io.InputStream;

public interface FlowInstanceService {

    /**
     * 分页查询流程实例
     * @param flowInstanceQuery
     */
    void page(FlowInstanceQuery flowInstanceQuery);

    /**
     * 激活流程实例
     * @param processInstanceId
     */
    void activateProcessInstanceById(String processInstanceId);

    /**
     * 挂起流程实例
     * @param processInstanceId
     */
    void suspendProcessInstanceById(String processInstanceId);

    /**
     * 删除流程实例
     * @param processInstanceId
     * @param deleteReason
     */
    void deleteProcessInstance(String processInstanceId, String deleteReason);

    /**
     * 启动流程实例
     * @param request
     */
    void startProcessInstanceById(ProcessInstanceCreateRequest request);

    /**
     * 获取流程图图片
     * @param processInstanceId
     */
    InputStream createImage(String processInstanceId);

    /**
     * 终止流程
     * @param processInstanceId
     */
    void stopProcessInstanceById(String processInstanceId) ;
}
