package cn.datax.service.data.quality.service.impl;

import cn.datax.service.data.quality.api.entity.CheckRuleEntity;
import cn.datax.service.data.quality.api.dto.CheckRuleDto;
import cn.datax.service.data.quality.service.CheckRuleService;
import cn.datax.service.data.quality.mapstruct.CheckRuleMapper;
import cn.datax.service.data.quality.dao.CheckRuleDao;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 核查规则信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-09-27
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class CheckRuleServiceImpl extends BaseServiceImpl<CheckRuleDao, CheckRuleEntity> implements CheckRuleService {

    @Autowired
    private CheckRuleDao checkRuleDao;

    @Autowired
    private CheckRuleMapper checkRuleMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CheckRuleEntity saveCheckRule(CheckRuleDto checkRuleDto) {
        CheckRuleEntity checkRule = checkRuleMapper.toEntity(checkRuleDto);
        checkRuleDao.insert(checkRule);
        return checkRule;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CheckRuleEntity updateCheckRule(CheckRuleDto checkRuleDto) {
        CheckRuleEntity checkRule = checkRuleMapper.toEntity(checkRuleDto);
        checkRuleDao.updateById(checkRule);
        return checkRule;
    }

    @Override
    public CheckRuleEntity getCheckRuleById(String id) {
        CheckRuleEntity checkRuleEntity = super.getById(id);
        return checkRuleEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteCheckRuleById(String id) {
        checkRuleDao.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteCheckRuleBatch(List<String> ids) {
        checkRuleDao.deleteBatchIds(ids);
    }
}
