package cn.datax.service.data.factory.api.entity;

import cn.datax.common.exception.DataException;
import cn.hutool.core.util.StrUtil;
import lombok.Data;

import java.io.Serializable;

@Data
public class DataSchema implements Serializable {

    private static final long serialVersionUID = 1L;

    private String jdbcUrl;
    private String username;
    private String password;

    /**
     * 参数合法性校验
     */
    public void viald() {
        if (StrUtil.isBlank(jdbcUrl) || StrUtil.isBlank(username) || StrUtil.isBlank(password)) {
            throw new DataException("参数不完整");
        }
    }
}
