package cn.datax.service.data.factory.api.vo;

import cn.datax.service.data.factory.api.entity.DataSchema;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 数据源信息表 实体VO
 * </p>
 *
 * @author yuwei
 * @since 2020-03-14
 */
@Data
public class DataSourceVo implements Serializable {

    private static final long serialVersionUID=1L;

    private String id;
    private Integer status;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;
    private String sourceType;
    private String sourceName;
    private String sourceDesc;
    private DataSchema sourceSchema;
}
