package cn.datax.common.base;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class BaseQueryParams implements Serializable {

    private static final long serialVersionUID = 1L;

    // 当前页码
    private Integer pageNum;
    // 分页条数
    private Integer pageSize;
    // 显示字段
    private List<String> columnList;
    // 排序
    private List<OrderItem> orderList;
    // 数据权限
    private String dataScope;

    @Data
    public class OrderItem{
        private String column;
        private boolean asc;
    }
}
