package cn.datax.service.system.controller;

import cn.datax.common.base.BaseController;
import cn.datax.common.core.DataUser;
import cn.datax.common.core.R;
import cn.datax.common.security.annotation.DataInner;
import cn.datax.common.utils.SecurityUtil;
import cn.datax.service.system.api.vo.UserInfo;
import cn.datax.service.system.service.UserService;
import cn.hutool.core.util.StrUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.util.Base64Utils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/inner")
public class LoginController extends BaseController {

    @Autowired
    private UserService userService;

    @Autowired
    private TokenStore tokenStore;

    @Autowired
    private RestTemplate restTemplate;

    @GetMapping("/token")
    public R getTokenUser() {
        DataUser user = SecurityUtil.getDataUser();
        return R.ok().setData(user);
    }

    @DataInner
    @PostMapping("/login")
    public R login(){
        MultiValueMap<String, String> formData = new LinkedMultiValueMap();
        HttpHeaders headers = new HttpHeaders();
//        headers.set("Authorization", this.getAuthorizationHeader(this.clientId, this.clientSecret));
        Map<String, Object> map = this.postForMap("", formData, headers);
        if (map.containsKey("error")) {
            return R.error();
        }
        return R.ok().setData(map);
    }

    @DataInner
    @GetMapping("/login/username/{username}")
    public R loginByUsername(@PathVariable String username) {
        UserInfo userInfo = userService.getUserByUsername(username);
        return R.ok().setData(userInfo);
    }

    @DeleteMapping("/logout/{token}")
    public R logout(@PathVariable("token") String token) {
        if (StrUtil.isBlank(token)) {
            return R.error("退出失败，Token为空");
        }
        OAuth2AccessToken accessToken = tokenStore.readAccessToken(token);
        if (accessToken == null || StrUtil.isBlank(accessToken.getValue())) {
            return R.ok();
        }
        tokenStore.removeAccessToken(accessToken);
        OAuth2RefreshToken refreshToken = accessToken.getRefreshToken();
        tokenStore.removeRefreshToken(refreshToken);
        return R.ok();
    }

    private String getAuthorizationHeader(String clientId, String clientSecret) {
        String creds = String.format("%s:%s", clientId, clientSecret);
        return "Basic " + new String(Base64Utils.encode(creds.getBytes()));
    }

    private Map<String, Object> postForMap(String path, MultiValueMap<String, String> formData, HttpHeaders headers) {
        Map map = restTemplate.exchange(path, HttpMethod.POST, new HttpEntity(formData, headers), Map.class, new Object[0]).getBody();
        return map;
    }
}
