package cn.datax.common.database;

import cn.datax.common.database.core.DbColumn;
import org.springframework.jdbc.core.RowMapper;

/**
 * 表数据查询接口
 *
 * @author yuwei
 * @since 2020-03-14
 */
public interface DbDialect {

    RowMapper<DbColumn> rowMapper();

    /**
     * 获取指定表的所有列
     *
     * @param tableName
     * @return
     */
    String columns(String tableName);

    /**
     * 获取数据库下的 所有表
     *
     * @param dbName
     * @return
     */
    String tables(String dbName);

    /**
     * 构建 分页 sql
     *
     * @param sql
     * @param offset
     * @param count
     * @return
     */
    String buildPaginationSql(String sql, long offset, long count);

    /**
     * 包装 count sql
     *
     * @param sql
     * @return
     */
    String count(String sql);
}
