package cn.datax.common.database.dialect;

import cn.datax.common.database.DbDialect;

/**
 * 方言抽象类
 *
 * @author yuwei
 * @since 2020-03-14
 */
public abstract class AbstractDbDialect implements DbDialect {

    @Override
    public String columns(String tableName) {
        return "show columns from `" + tableName + "`;";
    }

    @Override
    public String tables(String dbName) {
//        return "select table_name name, table_comment comment from information_schema.tables where table_schema = '" + dbName + "' and table_type = 'BASE TABLE' ";
        return "SELECT table_name name FROM information_schema.tables WHERE table_schema = '" + dbName + "' AND table_type = 'BASE TABLE' ";
    }

    @Override
    public String buildPaginationSql(String originalSql, long offset, long count) {
        // 获取 分页实际条数
        StringBuilder sqlBuilder = new StringBuilder(originalSql);
        sqlBuilder.append(" LIMIT ").append(offset).append(" , ").append(count);
        return sqlBuilder.toString();
    }

    @Override
    public String count(String sql) {
        return "SELECT COUNT(*) FROM ( " + sql + " ) TEMP";
    }
}
