package cn.datax.common.database.dialect;

import cn.datax.common.database.core.DbColumn;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;

/**
 * Oracle Oracle11g及以下数据库方言
 *
 * @author yuwei
 * @since 2020-03-14
 */
public class OracleDialect extends AbstractDbDialect {

    @Override
    public String columns(String tableName) {
        return "select * from user_tab_columns where table_name = '" + tableName + "' ";
    }

    @Override
    public String tables(String dbName) {
        return "SELECT table_name name FROM user_tables";
    }

    @Override
    public String buildPaginationSql(String originalSql, long offset, long count) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT * FROM ( SELECT TMP.*, ROWNUM ROW_ID FROM ( ");
        sqlBuilder.append(originalSql).append(" ) TMP WHERE ROWNUM <=").append((offset >= 1) ? (offset + count) : count);
        sqlBuilder.append(") WHERE ROW_ID > ").append(offset);
        return sqlBuilder.toString();
    }

    @Override
    public RowMapper<DbColumn> rowMapper() {
        return (ResultSet rs, int rowNum) -> {
            DbColumn entity = new DbColumn();
            entity.setName(rs.getString("COLUMN_NAME"));
            entity.setType(rs.getString("DATA_TYPE"));
            entity.setNullable(rs.getString("NULLABLE"));
            return entity;
        };
    }
}
