package cn.datax.service.data.factory.controller;

import cn.datax.common.base.BaseController;
import cn.datax.service.data.factory.api.entity.DataSetEntity;
import cn.datax.service.data.factory.api.entity.DataSourceEntity;
import cn.datax.service.data.factory.service.DataSetService;
import cn.datax.service.data.factory.service.DataSourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/inner")
public class InnerController extends BaseController {

    @Autowired
    private DataSourceService dataSourceService;

    @Autowired
    private DataSetService dataSetService;

    @GetMapping("/sources/{id}")
    public DataSourceEntity getDataSourceById(@PathVariable("id") String id) {
        DataSourceEntity dataSourceEntity = dataSourceService.getDataSourceById(id);
        return dataSourceEntity;
    }

    @GetMapping("/sets/{id}")
    public DataSetEntity getDataSetById(@PathVariable("id") String id) {
        DataSetEntity dataSetEntity = dataSetService.getDataSetById(id);
        return dataSetEntity;
    }
}
