import request from '@/utils/request'

export function listDataSource (data) {
  return request({
    url: '/data/factory/dataSources/list',
    method: 'get',
    params: data
  })
}

export function pageDataSource (data) {
  return request({
    url: '/data/factory/dataSources/page',
    method: 'get',
    params: data
  })
}

export function getDataSource (id) {
  return request({
    url: '/data/factory/dataSources/' + id,
    method: 'get'
  })
}

export function delDataSource (id) {
  return request({
    url: '/data/factory/dataSources/' + id,
    method: 'delete'
  })
}

export function delDataSources (ids) {
  return request({
    url: '/data/factory/dataSources/batch/' + ids,
    method: 'delete'
  })
}

export function addDataSource (data) {
  return request({
    url: '/data/factory/dataSources',
    method: 'post',
    data: data
  })
}

export function updateDataSource (data) {
  return request({
    url: '/data/factory/dataSources/' + data.id,
    method: 'put',
    data: data
  })
}

export function checkConnection (data) {
  return request({
    url: '/data/factory/dataSources/checkConnection',
    method: 'post',
    data: data
  })
}

export function queryByPage (data) {
  return request({
    url: '/data/factory/dataSources/queryByPage',
    method: 'post',
    data: data
  })
}

export function getDbTables (id) {
  return request({
    url: '/data/factory/dataSources/' + id + '/tables',
    method: 'get'
  })
}

export function getDbTableColumns (id, tableName) {
  return request({
    url: '/data/factory/dataSources/' + id + '/' + tableName + '/columns',
    method: 'get'
  })
}
