package cn.datax.common.database.datasource;

import cn.datax.common.database.DataSourceFactory;
import cn.datax.common.database.DbQuery;
import cn.datax.common.database.constants.DbQueryProperty;
import cn.datax.common.database.constants.DbType;
import cn.datax.common.database.exception.DataQueryException;
import cn.datax.common.database.query.MySqlDbQuery;
import com.zaxxer.hikari.HikariDataSource;

import javax.sql.DataSource;

public abstract class AbstractDataSourceFactory implements DataSourceFactory {

    @Override
    public DbQuery createDbQuery(DbQueryProperty property) {
        property.viald();
        DbType dbType = DbType.getDbType(property.getDbType());
        DataSource dataSource = createDataSource(property);
        DbQuery dbQuery = createDbQueryTemplate(dataSource, dbType);
        return dbQuery;
    }

    public DbQuery createDbQueryTemplate(DataSource dataSource, DbType dbType) {
        DbQuery dbQuery;
        switch (dbType) {
            case MYSQL: {
                dbQuery = new MySqlDbQuery(dataSource);
                break;
            }
            default: {
                throw new DataQueryException("不支持的数据库类型");
            }
        }
        return dbQuery;
    }

    public DataSource createDataSource(DbQueryProperty property) {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setJdbcUrl(property.getJdbcUrl());
        dataSource.setUsername(property.getUsername());
        dataSource.setPassword(property.getPassword());
        return dataSource;
    }
}
