package cn.datax.common.database.datasource;

import cn.datax.common.database.constants.DbQueryProperty;

import javax.sql.DataSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacheDataSourceFactoryBean extends AbstractDataSourceFactory {

    /**
     * 数据源缓存
     */
    private static Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<>();

    @Override
    public DataSource createDataSource(DbQueryProperty property) {
        String key = property.getJdbcUrl();
        DataSource dataSource = dataSourceMap.get(key);
        if (null == dataSource) {
            synchronized (CacheDataSourceFactoryBean.class) {
                if (null == dataSource) {
                    dataSource = super.createDataSource(property);
                    dataSourceMap.put(key, dataSource);
                }
            }
        }
        return dataSource;
    }
}
