package cn.datax.common.database.dialect;

import cn.datax.common.database.DbDialect;
import cn.datax.common.database.constants.DbType;

import java.util.*;

public class DialectRegistry {

    private final Map<DbType, DbDialect> dialect_enum_map = new EnumMap<>(DbType.class);

    public DialectRegistry() {
        dialect_enum_map.put(DbType.MYSQL, new MySqlDialect());
    }

    public DbDialect getDialect(DbType dbType) {
        return dialect_enum_map.get(dbType);
    }
}
