package cn.datax.service.data.factory.service.impl;

import cn.datax.common.database.DataSourceFactory;
import cn.datax.common.database.DbQuery;
import cn.datax.common.database.constants.DbQueryProperty;
import cn.datax.common.database.constants.DbType;
import cn.datax.common.database.datasource.CacheDataSourceFactoryBean;
import cn.datax.service.data.factory.api.dto.DataSourceDto;
import cn.datax.service.data.factory.api.entity.DbSchema;
import cn.datax.service.data.factory.api.entity.DataSourceEntity;
import cn.datax.service.data.factory.dao.DataSourceDao;
import cn.datax.service.data.factory.service.DataSourceService;
import cn.datax.service.data.factory.mapstruct.DataSourceMapper;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 数据源信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-03-14
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class DataSourceServiceImpl extends BaseServiceImpl<DataSourceDao, DataSourceEntity> implements DataSourceService {

    @Autowired
    private DataSourceDao dataSourceDao;

    @Autowired
    private DataSourceMapper dataSourceMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveDataSource(DataSourceDto dataSourceDto) {
        DataSourceEntity dataSource = dataSourceMapper.toEntity(dataSourceDto);
        dataSourceDao.insert(dataSource);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDataSource(DataSourceDto dataSourceDto) {
        DataSourceEntity dataSource = dataSourceMapper.toEntity(dataSourceDto);
        dataSourceDao.updateById(dataSource);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDataSourceById(String id) {
        dataSourceDao.deleteById(id);
    }

    @Override
    public Boolean checkConnection(DataSourceDto dataSourceDto) {
        DataSourceEntity dataSource = dataSourceMapper.toEntity(dataSourceDto);
        DbSchema dbSchema = dataSource.getDbSchema();
        DataSourceFactory dataSourceFactory = new CacheDataSourceFactoryBean();
        DbQueryProperty dbQueryProperty = new DbQueryProperty(dataSource.getDbType(), dbSchema.getJdbcUrl(), dbSchema.getUsername(), dbSchema.getPassword());
        DbQuery dbQuery = dataSourceFactory.createDbQuery(dbQueryProperty);
        boolean valid = false;
        try {
            valid = dbQuery.valid();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return valid;
    }

    @Override
    public List<String> getDbTypes() {
        return Arrays.stream(DbType.values()).map(s -> s.getDb()).collect(Collectors.toList());
    }
}
