package cn.datax.service.data.market.service.impl;

import cn.datax.common.core.R;
import cn.datax.common.database.DataSourceFactory;
import cn.datax.common.database.DbQuery;
import cn.datax.common.database.constants.DbQueryProperty;
import cn.datax.common.exception.DataException;
import cn.datax.common.utils.PageUtil;
import cn.datax.common.utils.ThrowableUtil;
import cn.datax.service.data.factory.api.dto.DbSchema;
import cn.datax.service.data.factory.api.entity.DataSourceEntity;
import cn.datax.service.data.factory.api.feign.DataSourceServiceFeign;
import cn.datax.service.data.market.api.entity.DataApiEntity;
import cn.datax.service.data.market.dao.DataApiDao;
import cn.datax.service.data.market.service.ApiService;
import cn.datax.service.data.market.utils.ThreadUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class ApiServiceImpl implements ApiService {

    @Autowired
    private DataSourceFactory dataSourceFactory;

    @Autowired
    private DataSourceServiceFeign dataSourceServiceFeign;

    @Autowired
    private DataApiDao dataApiDao;

    @Override
    public List<Map<String, Object>> v1() {
        DataApiEntity dataApiEntity = dataApiDao.selectById(ThreadUtil.get().getId());
        R result = dataSourceServiceFeign.getDataSourceById(dataApiEntity.getExecuteConfig().getSourceId());
        if(result == null || !result.isSuccess() || ObjectUtil.isEmpty(result.getData())){
            throw new DataException("API调用查询数据源出错");
        }
        DataSourceEntity dataSource = JSON.parseObject(JSON.toJSONString(result.getData()), DataSourceEntity.class);
        DbSchema dbSchema = dataSource.getDbSchema();
        DbQueryProperty dbQueryProperty = new DbQueryProperty(dataSource.getDbType(), dbSchema.getHost(),
                dbSchema.getUsername(), dbSchema.getPassword(), dbSchema.getPort(), dbSchema.getDbName());
        DbQuery dbQuery = dataSourceFactory.createDbQuery(dbQueryProperty);
        try {
            // 分页查询
            PageUtil pageUtil = new PageUtil(1, 20);
            Integer offset = pageUtil.getOffset();
            List<Map<String, Object>> list = dbQuery.queryList(dataApiEntity.getSqlText());
            return list;
        } catch (Exception e) {
            log.error("全局异常信息ex={}, StackTrace={}", e.getMessage(), ThrowableUtil.getStackTrace(e));
            ThreadUtil.get().setStatus(0);
            ThreadUtil.get().setMsg(e.getMessage());
            throw new DataException("API调用出错");
        }
    }
}
