package cn.datax.service.data.factory.api.feign.fallback;

import cn.datax.service.data.factory.api.entity.DataSetEntity;
import cn.datax.service.data.factory.api.feign.DataSetServiceFeign;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class DataSetServiceFeignFallbackImpl implements DataSetServiceFeign {

    @Setter
    private Throwable cause;

    @Override
    public DataSetEntity getDataSetById(String id) {
        log.error("feign 调用{}出错", id, cause);
        return null;
    }
}
