package cn.datax.service.data.standard.controller;

import cn.datax.common.core.DataConstant;
import cn.datax.common.core.JsonPage;
import cn.datax.common.core.R;
import cn.datax.common.validate.ValidationGroups;
import cn.datax.service.data.standard.api.dto.StandardTypeDto;
import cn.datax.service.data.standard.api.entity.StandardTypeEntity;
import cn.datax.service.data.standard.api.vo.StandardTypeVo;
import cn.datax.service.data.standard.api.query.StandardTypeQuery;
import cn.datax.service.data.standard.mapstruct.StandardTypeMapper;
import cn.datax.service.data.standard.service.StandardTypeService;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 标准类别信息表 前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2020-08-10
 */
@Api(tags = {"标准类别信息表"})
@RestController
@RequestMapping("/standard/standardType")
public class StandardTypeController extends BaseController {

    @Autowired
    private StandardTypeService standardTypeService;

    @Autowired
    private StandardTypeMapper standardTypeMapper;

    /**
     * 通过ID查询信息
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "获取详细信息", notes = "根据url的id来获取详细信息")
    @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path")
    @GetMapping("/{id}")
    public R getStandardTypeById(@PathVariable String id) {
        StandardTypeEntity standardTypeEntity = standardTypeService.getStandardTypeById(id);
        return R.ok().setData(standardTypeMapper.toVO(standardTypeEntity));
    }

    @ApiOperation(value = "获取列表", notes = "")
    @GetMapping("/list")
    public R getMetadataSourceList() {
        QueryWrapper<StandardTypeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("status", DataConstant.EnableState.ENABLE.getKey());
        List<StandardTypeEntity> list = standardTypeService.list(queryWrapper);
        List<StandardTypeVo> collect = list.stream().map(standardTypeMapper::toVO).collect(Collectors.toList());
        return R.ok().setData(collect);
    }

    /**
     * 分页查询信息
     *
     * @param standardTypeQuery
     * @return
     */
    @ApiOperation(value = "分页查询", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "standardTypeQuery", value = "查询实体standardTypeQuery", required = true, dataTypeClass = StandardTypeQuery.class)
    })
    @GetMapping("/page")
    public R getStandardTypePage(StandardTypeQuery standardTypeQuery) {
        QueryWrapper<StandardTypeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.like(StrUtil.isNotBlank(standardTypeQuery.getGbTypeCode()), "gb_type_code", standardTypeQuery.getGbTypeCode());
        queryWrapper.like(StrUtil.isNotBlank(standardTypeQuery.getGbTypeName()), "gb_type_name", standardTypeQuery.getGbTypeName());
        IPage<StandardTypeEntity> page = standardTypeService.page(new Page<>(standardTypeQuery.getPageNum(), standardTypeQuery.getPageSize()), queryWrapper);
        List<StandardTypeVo> collect = page.getRecords().stream().map(standardTypeMapper::toVO).collect(Collectors.toList());
        JsonPage<StandardTypeVo> jsonPage = new JsonPage<>(page.getCurrent(), page.getSize(), page.getTotal(), collect);
        return R.ok().setData(jsonPage);
    }

    /**
     * 添加
     * @param standardType
     * @return
     */
    @ApiOperation(value = "添加信息", notes = "根据standardType对象添加信息")
    @ApiImplicitParam(name = "standardType", value = "详细实体standardType", required = true, dataType = "StandardTypeDto")
    @PostMapping()
    public R saveStandardType(@RequestBody @Validated({ValidationGroups.Insert.class}) StandardTypeDto standardType) {
        StandardTypeEntity standardTypeEntity = standardTypeService.saveStandardType(standardType);
        return R.ok().setData(standardTypeMapper.toVO(standardTypeEntity));
    }

    /**
     * 修改
     * @param standardType
     * @return
     */
    @ApiOperation(value = "修改信息", notes = "根据url的id来指定修改对象，并根据传过来的信息来修改详细信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path"),
            @ApiImplicitParam(name = "standardType", value = "详细实体standardType", required = true, dataType = "StandardTypeDto")
    })
    @PutMapping("/{id}")
    public R updateStandardType(@PathVariable String id, @RequestBody @Validated({ValidationGroups.Update.class}) StandardTypeDto standardType) {
        StandardTypeEntity standardTypeEntity = standardTypeService.updateStandardType(standardType);
        return R.ok().setData(standardTypeMapper.toVO(standardTypeEntity));
    }

    /**
     * 删除
     * @param id
     * @return
     */
    @ApiOperation(value = "删除", notes = "根据url的id来指定删除对象")
    @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path")
    @DeleteMapping("/{id}")
    public R deleteStandardTypeById(@PathVariable String id) {
        standardTypeService.deleteStandardTypeById(id);
        return R.ok();
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除角色", notes = "根据url的ids来批量删除对象")
    @ApiImplicitParam(name = "ids", value = "ID集合", required = true, dataType = "List", paramType = "path")
    @DeleteMapping("/batch/{ids}")
    public R deleteStandardTypeBatch(@PathVariable List<String> ids) {
        standardTypeService.deleteStandardTypeBatch(ids);
        return R.ok();
    }
}
