package cn.datax.common.log.async;

import cn.datax.service.system.api.dto.LogDto;
import cn.datax.service.system.api.feign.LogServiceFeign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
public class AsyncTask {

    @Autowired
    private LogServiceFeign logServiceFeign;

    @Async("dataLogExecutor")
    public void doTask(LogDto logDto) {
        logServiceFeign.saveLog(logDto);
    }

}