package cn.datax.service.data.quality.schedule.task;

import cn.datax.common.core.DataConstant;
import cn.datax.common.database.DataSourceFactory;
import cn.datax.common.database.DbQuery;
import cn.datax.common.database.constants.DbQueryProperty;
import cn.datax.service.data.metadata.api.dto.DbSchema;
import cn.datax.service.data.metadata.api.entity.MetadataSourceEntity;
import cn.datax.service.data.metadata.api.feign.MetadataSourceServiceFeign;
import cn.datax.service.data.quality.api.entity.CheckRuleEntity;
import cn.datax.service.data.quality.service.CheckRuleService;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.*;

@Slf4j
@Component("qualityTask")
public class QualityTask {

    @Autowired
    private CheckRuleService checkRuleService;

    @Autowired
    private DataSourceFactory dataSourceFactory;

    @Autowired
    private MetadataSourceServiceFeign metadataSourceServiceFeign;

    public void task(Map<String, Object> map) {
        System.out.println("执行批次：" + map);
        // 获取可执行的核查规则
        List<CheckRuleEntity> list = checkRuleService.list(Wrappers.<CheckRuleEntity>lambdaQuery().eq(CheckRuleEntity::getStatus, DataConstant.TrueOrFalse.TRUE.getKey()));
        int poolSize = list.size();
        // 定义固定长度的线程池
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS,
                new LinkedBlockingQueue<Runnable>(16),
                new BasicThreadFactory.Builder().namingPattern("executor-schedule-pool-%d").daemon(true).build());
        // 定义计数器
        final CountDownLatch latch = new CountDownLatch(poolSize);
        list.stream().forEach(s -> executorTask(map, threadPoolExecutor, latch, s));
        // 主线程阻塞，等待所有子线程执行完成
        try {
            latch.await();
        } catch (InterruptedException e) {}
        // 关闭线程池
        threadPoolExecutor.shutdown();
    }

    private void executorTask(Map<String, Object> map, ThreadPoolExecutor threadPoolExecutor, CountDownLatch latch, CheckRuleEntity checkRuleEntity) {
        MetadataSourceEntity dataSource = null;
        try {
            dataSource = metadataSourceServiceFeign.getMetadataSourceById(checkRuleEntity.getRuleSourceId());
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (dataSource != null) {
            DbSchema dbSchema = dataSource.getDbSchema();
            DbQueryProperty dbQueryProperty = new DbQueryProperty(dataSource.getDbType(), dbSchema.getHost(),
                    dbSchema.getUsername(), dbSchema.getPassword(), dbSchema.getPort(), dbSchema.getDbName(), dbSchema.getSid());
            DbQuery dbQuery = dataSourceFactory.createDbQuery(dbQueryProperty);
            Connection conn = dbQuery.getConnection();
            Future<Map<String, Object>> future = threadPoolExecutor.submit(new TaskHander(checkRuleEntity.getRuleSql(), latch, conn));
            try {
                System.out.println("任务执行结果:" + future.get());
            } catch (Exception e) {
                e.printStackTrace();
            }
            // 核查报告
        }
    }
}
