package cn.datax.service.data.quality.schedule.task;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;

public class TaskHander implements Callable<Map<String, Object>> {

    private CountDownLatch latch;

    private Connection conn;

    private String sql;

    public TaskHander() {
        super();
    }

    public TaskHander(String sql, CountDownLatch latch, Connection conn) {
        super();
        this.sql = sql;
        this.latch = latch;
        this.conn = conn;
    }

    @Override
    public Map<String, Object> call() throws Exception {
        System.out.println(Thread.currentThread().getName() + "线程开始执行");
        System.out.println("执行sql:" + sql);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement(ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY);
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if(rs != null){
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            } catch (SQLException e) {}
        }
        latch.countDown();
        Map<String, Object> map = new HashMap<>();
        return map;
    }
}
