package cn.datax.service.file.controller;

import cn.datax.common.core.R;
import cn.datax.service.file.api.entity.FileEntity;
import cn.datax.service.file.service.FileService;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;
import org.springframework.web.multipart.MultipartFile;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2019-09-17
 */
@RestController
@RequestMapping("/file")
public class FileController extends BaseController {

    @Autowired
    private FileService fileService;

    @GetMapping("/{id}")
    public R getFileById(@PathVariable String id) {
        return R.ok().setData(fileService.getById(id));
    }

    @GetMapping("/page")
    public R getFilePage(Page page, FileEntity file) {
        return R.ok().setData(fileService.page(page, Wrappers.query(file)));
    }

    @PostMapping("/upload")
    public R upload(@RequestParam("file") MultipartFile file) {
        fileService.uploadFile(file);
        return R.ok();
    }

    @DeleteMapping("/{id}")
    public R deleteFile(@PathVariable String id) {
        fileService.deleteFileById(id);
        return R.ok();
    }

}

