package cn.datax.service.system.controller;

import cn.datax.common.base.BaseController;
import cn.datax.common.core.R;
import cn.datax.common.security.annotation.DataInner;
import cn.datax.service.system.api.vo.UserInfo;
import cn.datax.service.system.service.UserService;
import cn.hutool.core.util.StrUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

@Slf4j
@RestController
public class LoginController extends BaseController {

    @Autowired
    private UserService userService;

    @Autowired
    private TokenStore tokenStore;

    @Autowired
    private RestTemplate restTemplate;

    @Value("${security.oauth2.client.access-token-uri}")
    private String accessTokenUri;
    @Value("${security.oauth2.client.client-id}")
    private String clientId;
    @Value("${security.oauth2.client.client-secret}")
    private String clientSecret;
    @Value("${security.oauth2.client.scope}")
    private String scope;

    @DataInner
    @GetMapping("/login/username/{username}")
    public R loginByUsername(@PathVariable String username) {
        UserInfo userInfo = userService.getUserByUsername(username);
        return R.ok().setData(userInfo);
    }

    @PostMapping("/login")
    public R login(String username, String password) {
        MultiValueMap<String, String> paramsMap = new LinkedMultiValueMap<>();
        paramsMap.set("username", username);
        paramsMap.set("password", password);
        paramsMap.set("grant_type", "password");
        paramsMap.set("scope", scope);
        paramsMap.set("client_id", clientId);
        paramsMap.set("client_secret", clientSecret);
        HttpEntity<MultiValueMap<String, String>> request = new HttpEntity(paramsMap, null);
        Object object = restTemplate.postForObject(accessTokenUri, request, Object.class);
        if(null != object){
            return R.ok().setData(object);
        }
        return R.error();
    }

    @DeleteMapping("/logout/{token}")
    public R logout(@PathVariable("token") String token) {
        if (StrUtil.isBlank(token)) {
            return R.error("退出失败，Token为空");
        }
        OAuth2AccessToken accessToken = tokenStore.readAccessToken(token);
        if (accessToken == null || StrUtil.isBlank(accessToken.getValue())) {
            return R.ok();
        }
        tokenStore.removeAccessToken(accessToken);
        OAuth2RefreshToken refreshToken = accessToken.getRefreshToken();
        tokenStore.removeRefreshToken(refreshToken);
        return R.ok();
    }
}
