package cn.datax.learning.design.patterns.creational;

/**
 * 工厂模式（Factory Pattern）
 * 1.简单工厂模式又称静态工厂方法模式
 * 是由一个具体的类去创建其他类的实例，父类是相同的，父类是具体的。
 */
public class SimpleFactory {

    public static void main(String[] args) throws Exception {
        Factory factory = new Factory();
        factory.produce("PRO5").run();
        factory.produce("PRO6").run();
    }
}

//抽象产品类
interface MeizuPhone {
    void run();
}

//具体产品类
class PRO5 implements MeizuPhone {
    @Override
    public void run() {
        System.out.println("我是一台PRO5");
    }
}

//具体产品类
class PRO6 implements MeizuPhone {
    @Override
    public void run() {
        System.out.println("我是一台PRO6");
    }
}

//创建工厂类
class Factory{
    MeizuPhone produce(String produce) throws Exception {
        if (produce.equals("PRO5")) {
            return new PRO5();
        } else if (produce.equals("PRO6")) {
            return new PRO6();
        }
        throw new Exception("No Such Class");
    }
}