package cn.datax.service.data.masterdata.api.entity;

import cn.datax.common.base.DataScopeBaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 主数据模型表
 * </p>
 *
 * @author yuwei
 * @since 2020-08-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("masterdata_model")
public class ModelEntity extends DataScopeBaseEntity {

    private static final long serialVersionUID=1L;

    /**
     * 模型名称
     */
    private String modelName;

    /**
     * 模型编码
     */
    private String modelCode;

    /**
     * 模型数据库表
     */
    private String modelTable;

    @TableField(exist = false)
    private List<ModelColumnEntity> modelColumns;
}
