package cn.datax.service.data.metadata.service.impl;

import cn.datax.service.data.metadata.api.entity.MetadataTableEntity;
import cn.datax.service.data.metadata.api.dto.MetadataTableDto;
import cn.datax.service.data.metadata.service.MetadataTableService;
import cn.datax.service.data.metadata.mapstruct.MetadataTableMapper;
import cn.datax.service.data.metadata.dao.MetadataTableDao;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 数据库表信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-07-29
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class MetadataTableServiceImpl extends BaseServiceImpl<MetadataTableDao, MetadataTableEntity> implements MetadataTableService {

    @Autowired
    private MetadataTableDao metadataTableDao;

    @Autowired
    private MetadataTableMapper metadataTableMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MetadataTableEntity saveMetadataTable(MetadataTableDto metadataTableDto) {
        MetadataTableEntity metadataTableEntity = metadataTableMapper.toEntity(metadataTableDto);
        metadataTableDao.insert(metadataTableEntity);
        return metadataTableEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MetadataTableEntity updateMetadataTable(MetadataTableDto metadataTableDto) {
        MetadataTableEntity metadataTableEntity = metadataTableMapper.toEntity(metadataTableDto);
        metadataTableDao.updateById(metadataTableEntity);
        return metadataTableEntity;
    }

    @Override
    public MetadataTableEntity getMetadataTableById(String id) {
        MetadataTableEntity metadataTableEntity = super.getById(id);
        return metadataTableEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteMetadataTableById(String id) {
        metadataTableDao.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteMetadataTableBatch(List<String> ids) {
        metadataTableDao.deleteBatchIds(ids);
    }
}
