package cn.datax.service.data.standard.controller;

import cn.datax.common.base.BaseController;
import cn.datax.common.core.R;
import cn.datax.service.data.standard.service.DictMappingService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@Api(tags = {"字典对照映射"})
@RestController
@RequestMapping("/mappings")
public class DictMappingController extends BaseController {

    @Autowired
    private DictMappingService dictMappingService;

    @GetMapping("/{id}")
    public R getDictMapping(@PathVariable String id) {
        Map<String, Object> map = dictMappingService.getDictMapping(id);
        return R.ok().setData(map);
    }
}
