import Vue from 'vue'

import 'normalize.css/normalize.css'

import ElementUI from 'element-ui'
import '@/styles/element-variables.scss'

import '@/styles/index.scss'

import '@/assets/icons/iconfont.css'

import App from './App'
import store from './store'
import router from './router'

import '@/permission'
import '@/icons'

import perms from '@/directive/permission'

import { getDicts } from '@/api/system/dict'
import { getConfigKey } from '@/api/system/config'
import { selectDictLabel } from '@/utils/data-process'

// 全局方法挂载
Vue.prototype.getDicts = getDicts
Vue.prototype.getConfigKey = getConfigKey
Vue.prototype.selectDictLabel = selectDictLabel

Vue.use(ElementUI)

Vue.use(perms)

Vue.config.productionTip = false

new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app')
