package cn.datax.service.data.masterdata.service.impl;

import cn.datax.common.exception.DataException;
import cn.datax.service.data.masterdata.api.entity.ModelDataEntity;
import cn.datax.service.data.masterdata.api.query.ModelDataQuery;
import cn.datax.service.data.masterdata.dao.MysqlDynamicDao;
import cn.datax.service.data.masterdata.service.ModelDataService;
import cn.datax.service.data.masterdata.utils.SearchUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Service
public class ModelDataServiceImpl implements ModelDataService {

    @Autowired
    private MysqlDynamicDao dynamicDao;

    private static String DEFAULT_PRIMARY_KEY = "id";

    private static List<String> SUPER_COLUMNS = Arrays.asList("id", "create_time");

    @Override
    public IPage<Map<String, Object>> getPageModelDatas(ModelDataQuery modelDataQuery) {
        String tableName = modelDataQuery.getTableName();
        if (StrUtil.isBlank(tableName)) {
            throw new DataException("数据库表为空");
        }
        QueryWrapper queryWrapper = SearchUtil.parseWhereSql(modelDataQuery);
        List<String> columns = modelDataQuery.getColumns();
        columns.addAll(SUPER_COLUMNS);
        String[] array = columns.toArray(new String[columns.size()]);
        queryWrapper.select(array);
        IPage<Map<String, Object>> page = dynamicDao.getPageModelDatas(new Page<>(modelDataQuery.getPageNum(), modelDataQuery.getPageSize()), queryWrapper, tableName);
        return page;
    }

    @Override
    public void addModelData(ModelDataEntity modelDataEntity) {
        String tableName = modelDataEntity.getTableName();
        if (StrUtil.isBlank(tableName)) {
            throw new DataException("数据库表为空");
        }
        dynamicDao.insertData(modelDataEntity);
    }

    @Override
    public void updateModelData(ModelDataEntity modelDataEntity) {
        String tableName = modelDataEntity.getTableName();
        if (StrUtil.isBlank(tableName)) {
            throw new DataException("数据库表为空");
        }
        Map<String, Object> map = modelDataEntity.getDatas();
        if (!map.containsKey(DEFAULT_PRIMARY_KEY)) {
            throw new DataException("数据库主键为空");
        }
        dynamicDao.updateData(modelDataEntity);
    }

    @Override
    public void delModelData(ModelDataEntity modelDataEntity) {
        String tableName = modelDataEntity.getTableName();
        if (StrUtil.isBlank(tableName)) {
            throw new DataException("数据库表为空");
        }
        Map<String, Object> map = modelDataEntity.getDatas();
        if (!map.containsKey(DEFAULT_PRIMARY_KEY)) {
            throw new DataException("数据库主键为空");
        }
        dynamicDao.deleteData(modelDataEntity);
    }

    @Override
    public Map<String, Object> getModelDataById(ModelDataEntity modelDataEntity) {
        String tableName = modelDataEntity.getTableName();
        if (StrUtil.isBlank(tableName)) {
            throw new DataException("数据库表为空");
        }
        Map<String, Object> map = modelDataEntity.getDatas();
        if (!map.containsKey(DEFAULT_PRIMARY_KEY)) {
            throw new DataException("数据库主键为空");
        }
        Map<String, Object> data = dynamicDao.getData(modelDataEntity);
        return data;
    }
}
