package cn.datax.service.system.api.vo;

import cn.datax.common.annotation.DictAop;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class UserVo implements Serializable {

    private static final long serialVersionUID=1L;

    private String id;
    @DictAop(code = "sys_common_status")
    private String status;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;
    private String remark;
    private String username;
    private String nickname;
    private String password;
    private String email;
    private String phone;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate birthday;
    private String deptId;
    private DeptVo dept;
    private List<PostVo> posts;
    private List<RoleVo> roles;
}
