package cn.datax.service.data.market.mapping.config;

import cn.datax.common.rabbitmq.config.RabbitMqConstant;
import cn.datax.common.utils.ThrowableUtil;
import cn.datax.service.data.market.mapping.service.QueueHandlerService;
import com.rabbitmq.client.Channel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.Exchange;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.QueueBinding;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class RabbitMqListenerConfig {

    @Autowired
    private QueueHandlerService queueHandlerService;

    /**
     * Fanout 交换机
     * 消费注册
     * @return
     */
    @RabbitListener(bindings = @QueueBinding(exchange = @Exchange(name = RabbitMqConstant.FANOUT_EXCHANGE_API_RELEASE_NAME, type = "fanout", durable = "true", autoDelete = "false"),
            value = @Queue(value = RabbitMqConstant.FANOUT_EXCHANGE_QUEUE_TOPIC_API_RELEASE1, durable = "true", exclusive = "false", autoDelete = "false")))
    public String fanoutQueueRelease(String id, Channel channel, Message message) throws Exception {
        try {
            log.info("fanoutQueueRelease接收到了：{}", id);
            queueHandlerService.handlerRelease(id);
            // 手动确认
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
            return id;
        }catch (Exception e){
            log.error("全局异常信息ex={}, StackTrace={}", e.getMessage(), ThrowableUtil.getStackTrace(e));
            if (message.getMessageProperties().getRedelivered()){
                log.error("消息已处理,请勿重复处理！");
                // 拒绝消息
                channel.basicReject(message.getMessageProperties().getDeliveryTag(), false);
            }else {
                //记录日志
                log.error("消息消费失败处理：{}",e.getMessage());
                //第一个参数为消息的index，第二个参数是是否批量处理，第三个参数为是否让被拒绝的消息重新入队列
                channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
            }
        }
        return null;
    }

    /**
     * Fanout 交换机
     * 消费注销
     */
    @RabbitListener(bindings = @QueueBinding(exchange = @Exchange(name = RabbitMqConstant.FANOUT_EXCHANGE_API_CANCEL_NAME, type = "fanout", durable = "true", autoDelete = "false"),
            value = @Queue(value = RabbitMqConstant.FANOUT_EXCHANGE_QUEUE_TOPIC_API_CANCEL1, durable = "true", exclusive = "false", autoDelete = "false")))
    public String fanoutQueueCancel(String id, Channel channel, Message message) throws Exception {
        try {
            log.info("fanoutQueueCancel接收到了：{}", id);
            queueHandlerService.handlerCancel(id);
            // 手动确认
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
            return id;
        }catch (Exception e){
            log.error("全局异常信息ex={}, StackTrace={}", e.getMessage(), ThrowableUtil.getStackTrace(e));
            if (message.getMessageProperties().getRedelivered()){
                log.error("消息已处理,请勿重复处理！");
                // 拒绝消息
                channel.basicReject(message.getMessageProperties().getDeliveryTag(), false);
            }else {
                //记录日志
                log.error("消息消费失败处理：{}",e.getMessage());
                //第一个参数为消息的index，第二个参数是是否批量处理，第三个参数为是否让被拒绝的消息重新入队列
                channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
            }
        }
        return null;
    }
}
