package cn.datax.service.data.market.api.feign.fallback;

import cn.datax.common.core.R;
import cn.datax.service.data.market.api.feign.DataApiServiceFeign;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class DataApiServiceFeignFallbackImpl implements DataApiServiceFeign {

    @Setter
    private Throwable cause;

    @Override
    public R getDataApiById(String id) {
        log.error("feign 调用{}出错", id, cause);
        return null;
    }
}
