package cn.datax.common.dictionary.utils;

import cn.datax.common.redis.service.RedisService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
public class DictUtil {

    private DictUtil() {}

    private static volatile DictUtil instance;

    public static DictUtil getInstance() {
        if(instance == null) {
            synchronized (DictUtil.class) {
                if(instance == null) {
                    instance = new DictUtil();
                }
            }
        }
        return instance;
    }

    @Autowired
    private RedisService redisService;

    static {
        initDictionary();
    }

    // 初始化字典数据
    private static void initDictionary() {
        log.info("DictUtil初始化中...");
    }

    /**
     * 获取字典项
     * @param code
     */
    public void getDictItemList(String code) {

    }

    /**
     * 获取字典项值
     * @param code
     * @param text
     * @return
     */
    public String getDictItemValue(String code, String text) {
        return "test";
    }
}
