package cn.datax.common.database.constants;

import cn.datax.common.database.exception.DataQueryException;
import lombok.AllArgsConstructor;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;

@Data
@AllArgsConstructor
public class DbQueryProperty implements Serializable {

    private static final long serialVersionUID = 1L;

    private String dbType;
    private String jdbcUrl;
    private String username;
    private String password;

    /**
     * 参数合法性校验
     */
    public void viald() {
        if (StringUtils.isEmpty(jdbcUrl) || StringUtils.isEmpty(username) || StringUtils.isEmpty(password)) {
            throw new DataQueryException("参数不完整");
        }
        if (DbType.OTHER.getDb().equals(dbType)) {
            throw new DataQueryException("不支持的数据库类型");
        }
    }
}
