package cn.datax.service.data.factory.api.dto;

import cn.datax.common.validate.ValidationGroups;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@ApiModel(value = "数据源连接信息Model")
@Data
public class DbSchemaDto implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "JDBC URL")
    @NotBlank(message = "JDBC URL不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String jdbcUrl;
    @ApiModelProperty(value = "用户名")
    @NotBlank(message = "用户名不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String username;
    @ApiModelProperty(value = "密码")
    @NotBlank(message = "密码不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String password;
}
