package cn.datax.service.data.factory.service.impl;

import cn.datax.service.data.factory.api.dto.DataSetDto;
import cn.datax.service.data.factory.api.entity.DataSetEntity;
import cn.datax.service.data.factory.service.DataSetService;
import cn.datax.service.data.factory.mapstruct.DataSetMapper;
import cn.datax.service.data.factory.dao.DataSetDao;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 * 数据集信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-03-20
 */
@CacheConfig(cacheNames = "data:factory:sets")
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class DataSetServiceImpl extends BaseServiceImpl<DataSetDao, DataSetEntity> implements DataSetService {

    @Autowired
    private DataSetDao dataSetDao;

    @Autowired
    private DataSetMapper dataSetMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveDataSet(DataSetDto dataSetDto) {
        DataSetEntity dataSet = dataSetMapper.toEntity(dataSetDto);
        dataSetDao.insert(dataSet);
    }

    @CachePut(key = "#p0.id")
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDataSet(DataSetDto dataSetDto) {
        DataSetEntity dataSet = dataSetMapper.toEntity(dataSetDto);
        dataSetDao.updateById(dataSet);
    }

    @Cacheable(key = "#id", unless = "#result == null")
    @Override
    public DataSetEntity getDataSetById(String id) {
        DataSetEntity dataSetEntity = super.getById(id);
        return dataSetEntity;
    }

    @CacheEvict(key = "#id")
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDataSetById(String id) {
        dataSetDao.deleteById(id);
    }
}
