package cn.datax.service.system.api.vo;

import cn.datax.common.dictionary.annotation.DictAop;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 工作流配置信息表 实体VO
 * </p>
 *
 * @author yuwei
 * @since 2020-05-19
 */
@Data
public class WorkflowConfigVo implements Serializable {

    private static final long serialVersionUID=1L;

    private String id;
    @DictAop(code = "sys_common_status")
    private String status;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;
    private String remark;
    private String processKey;
    private String businessTheme;
    private String businessCode;
    private String businessComponent;
}
