package cn.datax.service.email.api.feign.fallback;

import cn.datax.common.core.R;
import cn.datax.service.email.api.dto.EmailDto;
import cn.datax.service.email.api.feign.EmailServiceFeign;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@AllArgsConstructor
public class EmailServiceFeignFallbackImpl implements EmailServiceFeign {

    private final Throwable cause;

    @Override
    public R sendMail(EmailDto mail) {
        log.error("feign 调用邮件出错,信息:{}", cause.getLocalizedMessage());
        return null;
    }
}
