package cn.datax.learning.design.patterns.behavioral.strategy;

/**
 * 策略模式（Strategy Pattern）
 */
public class StrategyPatternDemo {

    public static void main(String[] args) {
        Context context = new Context();
        context.SetStrategy(new OperationAdd());
        System.out.println("10 + 5 = " + context.executeStrategy(10, 5));
        context.SetStrategy(new OperationSubstract());
        System.out.println("10 - 5 = " + context.executeStrategy(10, 5));
        context.SetStrategy(new OperationMultiply());
        System.out.println("10 * 5 = " + context.executeStrategy(10, 5));
    }
}
