package cn.datax.service.data.market.data.masking.utils;

import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

public class ParsedSql implements Serializable {

    private static final long serialVersionUID=1L;

    public static void main(String[] args) {
        /**
         * 显示前三后四，其他隐藏为星号<例子：187****2488>
         */
        String phone = "18771632488";
        System.out.println(phone.replaceAll("(\\d{3}).*(\\d{4})","$1****$2"));
        /**
         * 显示前三后四，其他隐藏为星号<例子：421****464X>
         */
        String idCard = "421302199208165464X";
        System.out.println(idCard.replaceAll("(\\d{3}).*(\\w{4})", "$1****$2"));
        /**
         * 只显示前三后显示邮箱后缀，其他隐藏为星号<例子：312****@qq.com>
         */
        String email = "312075478@qq.com";
        System.out.println(email.replaceAll("(\\w{3}).*@(\\w+)", "$1****@$2"));
        /**
         * 只显示第一位，其他隐藏为星号<例子：张**>
         */
        String name = "张三";
        System.out.println(StringUtils.rightPad(StringUtils.left(name, 1), StringUtils.length(name), "*"));
        /**
         * 显示最后四位，其他隐藏为星号<例子：*************5762>
         */
        String other = "4213021992081655762";
        System.out.println(StringUtils.leftPad(StringUtils.right(other, 4), StringUtils.length(other), "*"));
    }

}
