package cn.datax.common.database.core;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

@Data
@Accessors(chain = true)
public class PageResult<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    private long pageNum;
    private long pageSize;
    private long total;
    private List<T> data;

    public PageResult(long total, List<T> data) {
        this.total = total;
        this.data = data;
    }
}
