package cn.datax.common.dictionary.config;

import cn.datax.common.core.JsonPage;
import cn.datax.common.core.R;
import cn.datax.common.dictionary.annotation.DictAop;
import cn.datax.common.dictionary.utils.DictUtil;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

@ControllerAdvice
public class DictAnalysis implements ResponseBodyAdvice {

    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Object beforeBodyWrite(Object o, MethodParameter methodParameter, MediaType mediaType, Class aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        if (o instanceof R) {
            if (((R) o).getData() instanceof JsonPage) {
                List list = ((JsonPage) ((R) o).getData()).getData();
                List<JSONObject> items = new ArrayList<>();
                for (Object record : list) {
                    String json = "{}";
                    try {
                        json = objectMapper.writeValueAsString(record);
                    } catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                    JSONObject item = JSONObject.parseObject(json);
                    for (Field field : record.getClass().getDeclaredFields()) {
                        // 获取自定义注解
                        DictAop dictAop = field.getAnnotation(DictAop.class);
                        if (null != dictAop) {
                            String code = dictAop.code();
                            String text = field.getName();
                            System.out.println("code:" + code);
                            System.out.println("field:" + text);
                            System.out.println("value:" + item.get(field.getName()));
                            // 字典翻译
                            String dictValue = DictUtil.getInstance().getDictItemValue(code, text);
                            item.put(field.getName() + "_dictText", dictValue);
                        }
                    }
                    items.add(item);
                }
                ((JsonPage) ((R) o).getData()).setData(items);
            }
        }
        return o;
    }

    @Override
    public boolean supports(MethodParameter methodParameter, Class aClass) {
        return true;
    }
}
