package cn.datax.service.system.controller;

import cn.datax.common.base.BaseController;
import cn.datax.common.core.R;
import cn.datax.common.security.annotation.DataInner;
import cn.datax.service.system.api.dto.LogDto;
import cn.datax.service.system.async.AsyncTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/inner")
public class InnerController extends BaseController {

    @Autowired
    private AsyncTask asyncTask;

    @DataInner
    @PostMapping("/logs")
    public R saveLog(@RequestBody LogDto log) {
        asyncTask.doTask(log);
        return R.ok();
    }
}
