package cn.datax.service.data.market.integration.service.impl;

import cn.datax.service.data.market.api.entity.ServiceIntegrationEntity;
import cn.datax.service.data.market.api.dto.ServiceIntegrationDto;
import cn.datax.service.data.market.integration.service.ServiceIntegrationService;
import cn.datax.service.data.market.integration.mapstruct.ServiceIntegrationMapper;
import cn.datax.service.data.market.integration.dao.ServiceIntegrationDao;
import cn.datax.common.base.BaseServiceImpl;
import cn.datax.service.data.market.integration.utils.SerialUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 服务集成表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-08-20
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class ServiceIntegrationServiceImpl extends BaseServiceImpl<ServiceIntegrationDao, ServiceIntegrationEntity> implements ServiceIntegrationService {

    @Autowired
    private ServiceIntegrationDao serviceIntegrationDao;

    @Autowired
    private ServiceIntegrationMapper serviceIntegrationMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ServiceIntegrationEntity saveServiceIntegration(ServiceIntegrationDto serviceIntegrationDto) {
        ServiceIntegrationEntity serviceIntegration = serviceIntegrationMapper.toEntity(serviceIntegrationDto);
        String serialNo = SerialUtil.getSerialNo(3);
        serviceIntegration.setServiceNo(serialNo);
        serviceIntegrationDao.insert(serviceIntegration);
        return serviceIntegration;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ServiceIntegrationEntity updateServiceIntegration(ServiceIntegrationDto serviceIntegrationDto) {
        ServiceIntegrationEntity serviceIntegration = serviceIntegrationMapper.toEntity(serviceIntegrationDto);
        serviceIntegrationDao.updateById(serviceIntegration);
        return serviceIntegration;
    }

    @Override
    public ServiceIntegrationEntity getServiceIntegrationById(String id) {
        ServiceIntegrationEntity serviceIntegrationEntity = super.getById(id);
        return serviceIntegrationEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteServiceIntegrationById(String id) {
        serviceIntegrationDao.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteServiceIntegrationBatch(List<String> ids) {
        serviceIntegrationDao.deleteBatchIds(ids);
    }
}
