package cn.datax.common.database.dialect;

import cn.datax.common.database.core.DbColumn;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;

/**
 * MySql 数据库方言
 *
 * @author yuwei
 * @since 2020-03-14
 */
public class MySqlDialect extends AbstractDbDialect {

    @Override
    public RowMapper<DbColumn> rowMapper() {
        return (ResultSet rs, int rowNum) -> {
            DbColumn entity = new DbColumn();
            entity.setName(rs.getString("Field"));
            entity.setType(rs.getString("Type"));
            entity.setNullable(rs.getString("Null"));
            entity.setHasKey(rs.getString("Key"));
            entity.setLength(rs.getString("Extra"));
            return entity;
        };
    }
}
