package cn.datax.service.data.factory.api.dto;

import cn.datax.common.validate.ValidationGroups;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
/**
 * <p>
 * 数据主题信息表 实体DTO
 * </p>
 *
 * @author yuwei
 * @since 2020-07-26
 */
@ApiModel(value = "数据主题信息表Model")
@Data
public class DataThemeDto implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "主键ID")
    @NotBlank(message = "主键ID不能为空", groups = {ValidationGroups.Update.class})
    private String id;
    @ApiModelProperty(value = "主题名称")
    @NotBlank(message = "主题名称不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String themeName;
}
